import { inspect, InspectOptions } from "util";
import V2 from "../V2";
export declare class CallForwarding {
    "callForwardingEnabled"?: boolean;
    "errorCode"?: number;
}
export declare class CallerName {
    "callerName"?: string;
    "callerType"?: string;
    "errorCode"?: number;
}
export declare class IdentityMatch {
    "firstNameMatch"?: string;
    "lastNameMatch"?: string;
    "addressLineMatch"?: string;
    "cityMatch"?: string;
    "stateMatch"?: string;
    "postalCodeMatch"?: string;
    "countryCodeMatch"?: string;
    "nationalIdMatch"?: string;
    "dateOfBirthMatch"?: string;
    "summaryScore"?: number;
    "errorCode"?: number;
    "errorMessage"?: string;
}
export declare class IdentityMatchParameters {
    "firstName"?: string;
    "lastName"?: string;
    "addressLine1"?: string;
    "addressLine2"?: string;
    "city"?: string;
    "state"?: string;
    "postalCode"?: string;
    "addressCountryCode"?: string;
    "nationalId"?: string;
    "dateOfBirth"?: string;
}
export declare class LastSimSwap {
    "lastSimSwapDate"?: Date;
    "swappedPeriod"?: string;
    "swappedInPeriod"?: boolean;
}
export declare class LineStatus {
    "status"?: string;
    "errorCode"?: number;
}
export declare class LineTypeIntelligence {
    "type"?: string;
    "carrierName"?: string;
    "mobileCountryCode"?: string;
    "mobileNetworkCode"?: string;
    "errorCode"?: number;
}
export declare class LookupRequest1 {
    "phoneNumbers"?: Array<LookupRequestWithCorId>;
}
export declare class LookupRequestWithCorId {
    /**
     * Unique identifier used to match request with response
     */
    "correlationId"?: string;
    "phoneNumber": string;
    "fields"?: Array<string>;
    "countryCode"?: string;
    "identityMatch"?: IdentityMatchParameters;
    "reassignedNumber"?: ReassignedNumberRequest;
    "smsPumpingRisk"?: SmsPumpingRiskParameters;
}
export declare class LookupResponseWithCorId {
    /**
     * Unique identifier used to match request with response
     */
    "correlationId"?: string;
    /**
     * Twilio error code in case that the request to downstream fails
     */
    "twilioErrorCode"?: number;
    "callingCountryCode"?: string;
    "countryCode"?: string;
    "phoneNumber"?: string;
    "nationalFormat"?: string;
    "valid"?: boolean;
    "validationErrors"?: Array<string>;
    "callerName"?: CallerName;
    "simSwap"?: SimSwap;
    "callForwarding"?: CallForwarding;
    "lineTypeIntelligence"?: LineTypeIntelligence;
    "lineStatus"?: LineStatus;
    "identityMatch"?: IdentityMatch;
    "reassignedNumber"?: ReassignedNumberResponse;
    "smsPumpingRisk"?: SmsPumpingRisk;
}
export declare class ReassignedNumberRequest {
    "lastVerifiedDate"?: string;
}
export declare class ReassignedNumberResponse {
    "lastVerifiedDate"?: string;
    "isNumberReassigned"?: string;
    "errorCode"?: string;
}
export declare class SimSwap {
    "lastSimSwap"?: LastSimSwap;
    "carrierName"?: string;
    "mobileCountryCode"?: string;
    "mobileNetworkCode"?: string;
    "errorCode"?: number;
}
export declare class SmsPumpingRisk {
    "carrierRiskCategory"?: string;
    "numberBlocked"?: boolean;
    "numberBlockedDate"?: Date;
    "numberBlockedLast3Months"?: boolean;
    "smsPumpingRiskScore"?: number;
    "errorCode"?: number;
}
export declare class SmsPumpingRiskParameters {
    "partnerSubId"?: string;
}
/**
 * Options to pass to create a QueryInstance
 */
export interface QueryListInstanceCreateOptions {
    /**  */
    lookupRequest1?: LookupRequest1;
}
export interface QuerySolution {
}
export interface QueryListInstance {
    _version: V2;
    _solution: QuerySolution;
    _uri: string;
    /**
     * Create a QueryInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed QueryInstance
     */
    create(callback?: (error: Error | null, item?: QueryInstance) => any): Promise<QueryInstance>;
    /**
     * Create a QueryInstance
     *
     * @param params - Body for request
     * @param headers - header params for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed QueryInstance
     */
    create(params: LookupRequest1, headers?: any, callback?: (error: Error | null, item?: QueryInstance) => any): Promise<QueryInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function QueryListInstance(version: V2): QueryListInstance;
interface QueryResource {
    phone_numbers: Array<LookupResponseWithCorId>;
}
export declare class QueryInstance {
    protected _version: V2;
    constructor(_version: V2, payload: QueryResource);
    phoneNumbers: Array<LookupResponseWithCorId>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        phoneNumbers: LookupResponseWithCorId[];
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export {};
