module.exports = (io) => {
   const namespace = io.of("/orders/delivery");
   namespace.on("connection", (socket) => {
      console.log("USUARIO SE CONECTO A SOCKET IO: /orders/delivery");

      socket.on("position", (data) => {
         console.log("CLIENTE EMITIO: ", data);
         namespace.emit(`position/${data.id_order}`, {
            id_order: data.id_order,
            lat: data.lat,
            lng: data.lng,
            estadoId: data.estadoId,

            /* //informacion para chat
            serv_hist_mensaje_id: data.serv_hist_mensaje_id,
            mensaje: data.mensaje,
            usuarioId: data.usuarioId,
            servicioHistorialId: data.servicioHistorialId,
            fechaFormateada: data.fechaFormateada, */
         });
      });

      socket.on("chat", (data) => {
         console.log("CHAT EMITIO: ", data);
         namespace.emit(`chat/${data.id_order}`, {
            id_order: data.id_order,
            //informacion para chat
            serv_hist_mensaje_id: data.serv_hist_mensaje_id,
            mensaje: data.mensaje,
            usuarioId: data.usuarioId,
            servicioHistorialId: data.servicioHistorialId,
            fechaFormateada: data.fechaFormateada,
         });
      });

      socket.on("chat-social", (data) => {
         console.log("mensaje de chat soscials", data);

         socket.emit(`chat-social/${data.id}`, {
            tipo_producto: data.tipo_producto,
            mensaje: data.mensaje,
         });

         //parte del administrador
         socket.emit(`chat-social`, data);
      });

      socket.on("disconnect", (data) => {
         console.log("UN USUARIO SE DESCONECTO DE SOCKET IO");
      });
   });
};
