const express = require("express");

const app = express();
const http = require("http");
const server = http.createServer(app);
const logger = require("morgan");
const cors = require("cors");
const io = require("socket.io")(server, {
  cors: { origin: "*" },
  path: "/socket.io", // 👈 corregido
});


//https://socket.io/docs/v3/handling-cors/

/* app.use(function (req, res, next) {
   res.header("Access-Control-Allow-Origin", "*");
   res.header("Access-Control-Allow-Headers", "X-Requested-With");
   res.header("Access-Control-Allow-Headers", "Content-Type");
   res.header(
      "Access-Control-Allow-Methods",
      "PUT, GET, POST, DELETE, OPTIONS",
   );
   next();
}); */

/*
 * IMPORTAR SOCKETS
 */
const ordersSocket = require("./sockets/ordersSocket");

const port = process.env.PORT || 3000;
const ip_servidor = "192.168.1.250";

app.use(logger("dev"));
app.use(express.json()); //parsear las respuestas que vengan en formato json
app.use(
   express.urlencoded({
      extended: true,
   }),
);

app.use(cors());
/* app.use(passport.initialize());
app.use(passport.session());
 */
app.disable("x-powered-by");

app.set("port", port);

/*
 * LLAMADO A LOS SOCKETS
 */
ordersSocket(io);

server.listen(3000, ip_servidor || "localhost", function () {
   console.log(
      "Aplicacion de NodeJS http://" +
         ip_servidor +
         ":" +
         port +
         " Iniciada...",
   );
});

// ERROR HANDLER
app.use((err, req, res, next) => {
   console.log(err);
   res.status(err.status || 500).send(err.stack);
});

app.get("/sockets_test_chat/", (req, res) => {
   res.send("Ruta raiz del backend");
});

app.get("/sockets_test_chat/test", (req, res) => {
   res.send("Estamos ruta test, funciona a la perfeccion");
});

app.get("/sockets_test_chat/unidad", (req, res) => {
   const data = {
      id_order: "330",
      lat: 15.492527,
      lng: -87.985257,
      estadoId: 2,
   };

   // usamos el getter del namespace
   const namespace = ordersSocket.getNamespace();
   namespace.emit(`position/${data.id_order}`, data);

   console.log("SE DISPARÓ POSITION DESDE HTTP:", data);

   res.send("Evento position disparado");
});

app.post("/sockets_test_chat/unidad_v1", (req, res) => {
   // Obtener los datos del cuerpo de la solicitud
   const data = req.body;

   // Validar que los datos necesarios estén presentes
   if (!data.id_order || !data.lat || !data.lng || !data.estadoId) {
      return res.status(400).json({ error: "Faltan campos requeridos" });
   }

   // Usar el getter del namespace de Socket.IO
   const namespace = ordersSocket.getNamespace();
   namespace.emit(`position/${data.id_order}`, data);

   console.log("SE DISPARÓ POSITION DESDE HTTP (POST):", data);

   res.status(200).json({ message: "Evento position disparado", data });
});

// 200 - ES UN RESPUESTA EXITOSA
// 404 - SIGNIFICA QUE LA URL NO EXISTE
// 500 - ERROR INTERNO DEL SERVIDOR
