let namespace; // variable global del módulo

module.exports = (io) => {
   namespace = io.of("/orders/delivery");

   namespace.on("connection", (socket) => {
      console.log("USUARIO SE CONECTO A SOCKET IO: /orders/delivery");

      socket.on("position", (data) => {
         console.log("CLIENTE EMITIO: ", data);
         namespace.emit(`position/${data.id_order}`, {
            id_order: data.id_order,
            lat: data.lat,
            lng: data.lng,
            estadoId: data.estadoId,
         });
      });

      socket.on("chat", (data) => {
         console.log("CHAT EMITIO: ", data);
         namespace.emit(`chat/${data.id_order}`, {
            id_order: data.id_order,
            serv_hist_mensaje_id: data.serv_hist_mensaje_id,
            mensaje: data.mensaje,
            usuarioId: data.usuarioId,
            servicioHistorialId: data.servicioHistorialId,
            fechaFormateada: data.fechaFormateada,
         });
      });

      socket.on("disconnect", () => {
         console.log("UN USUARIO SE DESCONECTO DE SOCKET IO");
      });
   });
};

// exportamos la referencia para usarla en server.js
module.exports.getNamespace = () => namespace;
