"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Conversations
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationWithParticipantsInstance = void 0;
exports.ConversationWithParticipantsListInstance = ConversationWithParticipantsListInstance;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
function ConversationWithParticipantsListInstance(version, chatServiceSid) {
    if (!(0, utility_1.isValidPathParam)(chatServiceSid)) {
        throw new Error("Parameter 'chatServiceSid' is not valid.");
    }
    const instance = {};
    instance._version = version;
    instance._solution = { chatServiceSid };
    instance._uri = `/Services/${chatServiceSid}/ConversationWithParticipants`;
    instance.create = function create(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["friendlyName"] !== undefined)
            data["FriendlyName"] = params["friendlyName"];
        if (params["uniqueName"] !== undefined)
            data["UniqueName"] = params["uniqueName"];
        if (params["dateCreated"] !== undefined)
            data["DateCreated"] = serialize.iso8601DateTime(params["dateCreated"]);
        if (params["dateUpdated"] !== undefined)
            data["DateUpdated"] = serialize.iso8601DateTime(params["dateUpdated"]);
        if (params["messagingServiceSid"] !== undefined)
            data["MessagingServiceSid"] = params["messagingServiceSid"];
        if (params["attributes"] !== undefined)
            data["Attributes"] = params["attributes"];
        if (params["state"] !== undefined)
            data["State"] = params["state"];
        if (params["timers.inactive"] !== undefined)
            data["Timers.Inactive"] = params["timers.inactive"];
        if (params["timers.closed"] !== undefined)
            data["Timers.Closed"] = params["timers.closed"];
        if (params["bindings.email.address"] !== undefined)
            data["Bindings.Email.Address"] = params["bindings.email.address"];
        if (params["bindings.email.name"] !== undefined)
            data["Bindings.Email.Name"] = params["bindings.email.name"];
        if (params["participant"] !== undefined)
            data["Participant"] = serialize.map(params["participant"], (e) => e);
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["Accept"] = "application/json";
        if (params["xTwilioWebhookEnabled"] !== undefined)
            headers["X-Twilio-Webhook-Enabled"] = params["xTwilioWebhookEnabled"];
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ConversationWithParticipantsInstance(operationVersion, payload, instance._solution.chatServiceSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class ConversationWithParticipantsInstance {
    constructor(_version, payload, chatServiceSid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.chatServiceSid = payload.chat_service_sid;
        this.messagingServiceSid = payload.messaging_service_sid;
        this.sid = payload.sid;
        this.friendlyName = payload.friendly_name;
        this.uniqueName = payload.unique_name;
        this.attributes = payload.attributes;
        this.state = payload.state;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.timers = payload.timers;
        this.links = payload.links;
        this.bindings = payload.bindings;
        this.url = payload.url;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            chatServiceSid: this.chatServiceSid,
            messagingServiceSid: this.messagingServiceSid,
            sid: this.sid,
            friendlyName: this.friendlyName,
            uniqueName: this.uniqueName,
            attributes: this.attributes,
            state: this.state,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            timers: this.timers,
            links: this.links,
            bindings: this.bindings,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ConversationWithParticipantsInstance = ConversationWithParticipantsInstance;
