"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.InteractionTransferInstance = exports.InteractionTransferContextImpl = void 0;
exports.InteractionTransferListInstance = InteractionTransferListInstance;
const util_1 = require("util");
const deserialize = require("../../../../../base/deserialize");
const serialize = require("../../../../../base/serialize");
const utility_1 = require("../../../../../base/utility");
class InteractionTransferContextImpl {
    constructor(_version, interactionSid, channelSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(interactionSid)) {
            throw new Error("Parameter 'interactionSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(channelSid)) {
            throw new Error("Parameter 'channelSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { interactionSid, channelSid, sid };
        this._uri = `/Interactions/${interactionSid}/Channels/${channelSid}/Transfers/${sid}`;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InteractionTransferInstance(operationVersion, payload, instance._solution.interactionSid, instance._solution.channelSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, headers, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InteractionTransferInstance(operationVersion, payload, instance._solution.interactionSid, instance._solution.channelSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.InteractionTransferContextImpl = InteractionTransferContextImpl;
class InteractionTransferInstance {
    constructor(_version, payload, interactionSid, channelSid, sid) {
        this._version = _version;
        this.sid = payload.sid;
        this.instanceSid = payload.instance_sid;
        this.accountSid = payload.account_sid;
        this.interactionSid = payload.interaction_sid;
        this.channelSid = payload.channel_sid;
        this.executionSid = payload.execution_sid;
        this.type = payload.type;
        this.status = payload.status;
        this.from = payload.from;
        this.to = payload.to;
        this.noteSid = payload.note_sid;
        this.summarySid = payload.summary_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.url = payload.url;
        this._solution = { interactionSid, channelSid, sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new InteractionTransferContextImpl(this._version, this._solution.interactionSid, this._solution.channelSid, this._solution.sid);
        return this._context;
    }
    /**
     * Fetch a InteractionTransferInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed InteractionTransferInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            sid: this.sid,
            instanceSid: this.instanceSid,
            accountSid: this.accountSid,
            interactionSid: this.interactionSid,
            channelSid: this.channelSid,
            executionSid: this.executionSid,
            type: this.type,
            status: this.status,
            from: this.from,
            to: this.to,
            noteSid: this.noteSid,
            summarySid: this.summarySid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.InteractionTransferInstance = InteractionTransferInstance;
function InteractionTransferListInstance(version, interactionSid, channelSid) {
    if (!(0, utility_1.isValidPathParam)(interactionSid)) {
        throw new Error("Parameter 'interactionSid' is not valid.");
    }
    if (!(0, utility_1.isValidPathParam)(channelSid)) {
        throw new Error("Parameter 'channelSid' is not valid.");
    }
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new InteractionTransferContextImpl(version, interactionSid, channelSid, sid);
    };
    instance._version = version;
    instance._solution = { interactionSid, channelSid };
    instance._uri = `/Interactions/${interactionSid}/Channels/${channelSid}/Transfers`;
    instance.create = function create(params, headers, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InteractionTransferInstance(operationVersion, payload, instance._solution.interactionSid, instance._solution.channelSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
