"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptedSentencesInstance = exports.EncryptedSentencesContextImpl = void 0;
exports.EncryptedSentencesListInstance = EncryptedSentencesListInstance;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class EncryptedSentencesContextImpl {
    constructor(_version, transcriptSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(transcriptSid)) {
            throw new Error("Parameter 'transcriptSid' is not valid.");
        }
        this._solution = { transcriptSid };
        this._uri = `/Transcripts/${transcriptSid}/Sentences/Encrypted`;
    }
    fetch(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["redacted"] !== undefined)
            data["Redacted"] = serialize.bool(params["redacted"]);
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new EncryptedSentencesInstance(operationVersion, payload, instance._solution.transcriptSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.EncryptedSentencesContextImpl = EncryptedSentencesContextImpl;
class EncryptedSentencesInstance {
    constructor(_version, payload, transcriptSid) {
        this._version = _version;
        this.location = payload.location;
        this.transcriptSid = payload.transcript_sid;
        this.url = payload.url;
        this._solution = { transcriptSid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new EncryptedSentencesContextImpl(this._version, this._solution.transcriptSid);
        return this._context;
    }
    fetch(params, callback) {
        return this._proxy.fetch(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            location: this.location,
            transcriptSid: this.transcriptSid,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.EncryptedSentencesInstance = EncryptedSentencesInstance;
function EncryptedSentencesListInstance(version, transcriptSid) {
    if (!(0, utility_1.isValidPathParam)(transcriptSid)) {
        throw new Error("Parameter 'transcriptSid' is not valid.");
    }
    const instance = (() => instance.get());
    instance.get = function get() {
        return new EncryptedSentencesContextImpl(version, transcriptSid);
    };
    instance._version = version;
    instance._solution = { transcriptSid };
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
