"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApproveChallengeInstance = exports.ApprovePasskeysChallengeRequestResponse = exports.ApprovePasskeysChallengeRequest = void 0;
exports.ApproveChallengeListInstance = ApproveChallengeListInstance;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class ApprovePasskeysChallengeRequest {
}
exports.ApprovePasskeysChallengeRequest = ApprovePasskeysChallengeRequest;
/**
 * The result of a WebAuthn authentication via a `navigator.credentials.get()` request, as specified in [AuthenticatorAttestationResponse](https://developer.mozilla.org/en-US/docs/Web/API/AuthenticatorAttestationResponse).
 */
class ApprovePasskeysChallengeRequestResponse {
}
exports.ApprovePasskeysChallengeRequestResponse = ApprovePasskeysChallengeRequestResponse;
function ApproveChallengeListInstance(version, serviceSid) {
    if (!(0, utility_1.isValidPathParam)(serviceSid)) {
        throw new Error("Parameter 'serviceSid' is not valid.");
    }
    const instance = {};
    instance._version = version;
    instance._solution = { serviceSid };
    instance._uri = `/Services/${serviceSid}/Passkeys/ApproveChallenge`;
    instance.update = function update(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ApproveChallengeInstance(operationVersion, payload, instance._solution.serviceSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class ApproveChallengeInstance {
    constructor(_version, payload, serviceSid) {
        this._version = _version;
        this.options = payload.options;
        this.sid = payload.sid;
        this.accountSid = payload.account_sid;
        this.serviceSid = payload.service_sid;
        this.entitySid = payload.entity_sid;
        this.identity = payload.identity;
        this.factorSid = payload.factor_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.dateResponded = deserialize.iso8601DateTime(payload.date_responded);
        this.expirationDate = deserialize.iso8601DateTime(payload.expiration_date);
        this.status = payload.status;
        this.respondedReason = payload.responded_reason;
        this.details = payload.details;
        this.hiddenDetails = payload.hidden_details;
        this.metadata = payload.metadata;
        this.factorType = payload.factor_type;
        this.url = payload.url;
        this.links = payload.links;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            options: this.options,
            sid: this.sid,
            accountSid: this.accountSid,
            serviceSid: this.serviceSid,
            entitySid: this.entitySid,
            identity: this.identity,
            factorSid: this.factorSid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            dateResponded: this.dateResponded,
            expirationDate: this.expirationDate,
            status: this.status,
            respondedReason: this.respondedReason,
            details: this.details,
            hiddenDetails: this.hiddenDetails,
            metadata: this.metadata,
            factorType: this.factorType,
            url: this.url,
            links: this.links,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ApproveChallengeInstance = ApproveChallengeInstance;
