"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewChallengeInstance = exports.NewChallengeContextImpl = exports.CreatePasskeysChallengeRequest = void 0;
exports.NewChallengeListInstance = NewChallengeListInstance;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class CreatePasskeysChallengeRequest {
}
exports.CreatePasskeysChallengeRequest = CreatePasskeysChallengeRequest;
class NewChallengeContextImpl {
    constructor(_version, serviceSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(serviceSid)) {
            throw new Error("Parameter 'serviceSid' is not valid.");
        }
        this._solution = { serviceSid };
        this._uri = `/Services/${serviceSid}/Passkeys/Challenges`;
    }
    create(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new NewChallengeInstance(operationVersion, payload, instance._solution.serviceSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.NewChallengeContextImpl = NewChallengeContextImpl;
class NewChallengeInstance {
    constructor(_version, payload, serviceSid) {
        this._version = _version;
        this.options = payload.options;
        this.sid = payload.sid;
        this.accountSid = payload.account_sid;
        this.serviceSid = payload.service_sid;
        this.entitySid = payload.entity_sid;
        this.identity = payload.identity;
        this.factorSid = payload.factor_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.dateResponded = deserialize.iso8601DateTime(payload.date_responded);
        this.expirationDate = deserialize.iso8601DateTime(payload.expiration_date);
        this.status = payload.status;
        this.respondedReason = payload.responded_reason;
        this.details = payload.details;
        this.hiddenDetails = payload.hidden_details;
        this.metadata = payload.metadata;
        this.factorType = payload.factor_type;
        this.url = payload.url;
        this.links = payload.links;
        this._solution = { serviceSid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new NewChallengeContextImpl(this._version, this._solution.serviceSid);
        return this._context;
    }
    create(params, callback) {
        return this._proxy.create(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            options: this.options,
            sid: this.sid,
            accountSid: this.accountSid,
            serviceSid: this.serviceSid,
            entitySid: this.entitySid,
            identity: this.identity,
            factorSid: this.factorSid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            dateResponded: this.dateResponded,
            expirationDate: this.expirationDate,
            status: this.status,
            respondedReason: this.respondedReason,
            details: this.details,
            hiddenDetails: this.hiddenDetails,
            metadata: this.metadata,
            factorType: this.factorType,
            url: this.url,
            links: this.links,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.NewChallengeInstance = NewChallengeInstance;
function NewChallengeListInstance(version, serviceSid) {
    if (!(0, utility_1.isValidPathParam)(serviceSid)) {
        throw new Error("Parameter 'serviceSid' is not valid.");
    }
    const instance = (() => instance.get());
    instance.get = function get() {
        return new NewChallengeContextImpl(version, serviceSid);
    };
    instance._version = version;
    instance._solution = { serviceSid };
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
